/*global jQuery*/
/**
 * nsw-police-2017
 * Global JS
 *
 * version: 0.0.1
 * file:    global.js
 * author:  Squiz Australia
 * change log: 
 * <date removed for GIT cleanliness>
 */

/*
 * Table of Contents
 *
 * - Global
 * - Modules

 */
'use strict';
/*
--------------------
Global
--------------------
*/
//  Declare JS Enabled.
//$('body').removeClass('no-js').addClass('js-enabled');


// Polyfill for CustomEvent

(function () {

  if (typeof window.CustomEvent === "function") return false;

  function CustomEvent(event, params) {
    params = params || { bubbles: false, cancelable: false, detail: undefined };
    var evt = document.createEvent('CustomEvent');
    evt.initCustomEvent(event, params.bubbles, params.cancelable, params.detail);
    return evt;
  }

  CustomEvent.prototype = window.Event.prototype;

  window.CustomEvent = CustomEvent;
})();

// Polyfill for matches & closest

(function (ElementProto) {
  if (typeof ElementProto.matches !== 'function') {
    ElementProto.matches = ElementProto.msMatchesSelector || ElementProto.mozMatchesSelector || ElementProto.webkitMatchesSelector || function matches(selector) {
      var element = this;
      var elements = (element.document || element.ownerDocument).querySelectorAll(selector);
      var index = 0;

      while (elements[index] && elements[index] !== element) {
        ++index;
      }

      return Boolean(elements[index]);
    };
  }

  if (typeof ElementProto.closest !== 'function') {
    ElementProto.closest = function closest(selector) {
      var element = this;

      while (element && element.nodeType === 1) {
        if (element.matches(selector)) {
          return element;
        }

        element = element.parentNode;
      }

      return null;
    };
  }
})(window.Element.prototype);

// Global Variables
var $body = $('body');

$.Sq = $.Sq || {};

$(init);
function init() {
  $.Sq.Accordion.init();
  $.Sq.Menu.init();
  $.Sq.Card.init();
  $.Sq.Contact.init();
  $.Sq.DecisionTree.init();
  $.Sq.SocialTab.init();

  $('.p-quicklinks__list').masonry();
}

$.Sq.Menu = function (module) {
  module.toggleMenuPanel = function () {
    var $menuBtn = $('.js-menu-btn');
    var menuStatus = 'is-menu-open';

    $menuBtn.on('click', function (e) {
      e.preventDefault();

      if ($body.hasClass(menuStatus)) {
        $body.removeClass(menuStatus);
      } else {
        $body.addClass(menuStatus);

        //add focus to search input
        //wont work on iOS
        if ($(this).hasClass('p-nav__search-btn')) {
          $('.o-page-container').one('webkitTransitionEnd otransitionend oTransitionEnd msTransitionEnd transitionend', function (ev) {
            if ($(ev.target).css('transform') !== 'none' && ev.target.classList.contains('o-page-container')) {
              $('header .p-footer__search-input').focus();
            }
          });
        }
      }
    });
  };

  module.toggleSubmenuMobile = function () {
    // Init
    $('.p-nav__menu-item.is-menu-current .p-nav__submenu--mobile').show();

    // Toggle
    var $arrowBtn = $('.js-menu-accordion');

    $arrowBtn.on('click', function (e) {
      e.preventDefault();

      var $this = $(this),
          $thisParent = $this.parent(),
          $thisTarget = $($this.attr('href'));

      if ($thisParent.hasClass('is-menu-current')) {
        $thisTarget.velocity('slideUp');
        $thisParent.removeClass('is-menu-current');
      } else {
        $thisTarget.velocity('slideDown');
        $thisParent.addClass('is-menu-current');
      }
    });
  };

  function hoverState($target, action) {
    if (action === 'mouseenter') {
      $target.addClass('is-submenu-open');
    } else {
      $target.removeClass('is-submenu-open');
    }
  }

  module.hoverSubmenu = function () {
    var $firstLvlMenu = $('.p-nav__menu-link');

    $firstLvlMenu.hoverIntent(function () {
      var $this = $(this),
          $thisTarget = $($this.attr('link-data'));

      hoverState($thisTarget, 'mouseenter');
    }, function () {
      var $this = $(this),
          $thisTarget = $($this.attr('link-data'));

      hoverState($thisTarget, 'mouseleave');
    });

    // Display the bar in the first level menu on hover of submenu panel
    var $firstLvlPanel = $('.p-nav__submenu');

    $firstLvlPanel.hover(function () {
      var $this = $(this),
          $thisTarget = $('#' + $this.attr('id') + '-link');

      hoverState($thisTarget, 'mouseenter');
    }, function () {
      var $this = $(this),
          $thisTarget = $('#' + $this.attr('id') + '-link');

      hoverState($thisTarget, 'mouseleave');
    });
  };

  module.init = function () {
    // load masonry
    module.toggleMenuPanel();
    module.toggleSubmenuMobile();
    module.hoverSubmenu();
  };

  return module;
}($.Sq.Menu || {});

$.Sq.Card = function (module) {
  module.masonry = function () {
    //setTimeout(function() {
    $('.p-card--masonry').masonry({
      itemSelector: '.p-card--masonry li',
      gutter: 20
    });
    //}, 500);

    setTimeout(function () {
      $('.p-card--masonry').masonry({
        itemSelector: '.p-card--masonry li',
        gutter: 20
      });
    }, 500);
  };

  module.updateMarkup = function () {
    var $cardLink = $('.p-card a'); //$this.siblings('a');

    $cardLink.each(function () {
      var $this = $(this),
          $thisTime = $this.siblings('em');

      // wrap text inside <a>
      $this.wrapInner('<span></span>');

      // move time in <a>
      $thisTime.prependTo($this);
    });
  };

  module.timeago = function () {
    var cardTime = $('.p-card--timeago em');

    cardTime.each(function () {
      var $this = $(this);

      $this.text($.timeago($this.text().replace('Tuesday', 'tuesday').replace('Thursday', 'thursday')).replace('about', ''));
    });
  };

  module.loadmore = function () {
    // Init
    var $cardBtn = $('.js-card-btn');
    var $cardCount = $('#card-count');
    var fromIndexInit = 0,
        totalIndex = 0;

    $cardBtn.each(function () {
      var $this = $(this);

      totalIndex = $this.parent().prev().find('li').length;
      fromIndexInit = parseFloat($this.attr('data-init')) - 1;
    });

    //let $initHide = $('.p-card li:nth-child(n+' + fromIndexInit + ')');
    var $initHide = $('.p-card li:gt(' + fromIndexInit + ')');

    if (fromIndexInit !== 0) {
      $initHide.hide();
    }

    $('.p-card--masonry').masonry('layout');

    // on Click
    $cardBtn.on('click', function (e) {
      e.preventDefault();

      var $this = $(this),
          $thisTarget = $this.parent().prev();
      var fromIndex = parseFloat($this.attr('data-init')),
          countIndex = parseFloat($this.attr('data-count')),
          toIndex = fromIndex + countIndex,
          nextIndex = toIndex + 1,
          cardCount = nextIndex - 1;

      //$this.hide();

      $thisTarget.find('li').slice(fromIndex, toIndex).velocity('fadeIn', {
        complete: function complete() {
          $('.p-card--masonry').masonry('layout');
          //$this.show();
          $this.attr('data-init', nextIndex);
          $cardCount.html(cardCount);

          if (toIndex >= totalIndex) {
            $this.hide();
          };
        }
      });
    });
  };

  module.init = function () {
    // load masonry
    module.masonry();
    module.updateMarkup();
    module.timeago();
    module.loadmore();
  };

  return module;
}($.Sq.Card || {});

$.Sq.Contact = function (module) {
  module.expandEvent = new CustomEvent('$.Sq.Contact.contactPanelExpanded');

  module.togglePanel = function () {
    var $contactBtn = $('.js-toggle-contact');

    $contactBtn.on('click', function (e) {
      e.preventDefault();

      var $this = $(this),
          $thisTarget = $($this.attr('href'));

      if ($this.hasClass('is-contact-open')) {
        // collapse
        $thisTarget.velocity('slideUp');
        $this.removeClass('is-contact-open');
      } else {
        // expand
        $thisTarget.velocity('slideDown');
        $this.addClass('is-contact-open');

        setTimeout(function () {
          return window.dispatchEvent(module.expandEvent);
        }, 100);
      }
    });
  };

  module.closePanel = function () {
    var $contactCloseBtn = $('.js-contact-close');

    $contactCloseBtn.on('click', function (e) {
      e.preventDefault();

      var $this = $(this),
          $thisTarget = $($this.attr('href')),
          $contactBtn = $('.js-toggle-contact');

      $thisTarget.velocity('slideUp');
      $contactBtn.removeClass('is-contact-open');
    });
  };

  module.init = function () {
    // load masonry
    module.togglePanel();
    module.closePanel();
  };

  return module;
}($.Sq.Contact || {});

$.Sq.SocialTab = function (module) {
  module.toggleTab = function () {
    var $tabBtn = $('.p-socialmedia__link'),
        $tabItems = $('.p-socialmedia__item'),
        $tabSection = $('.p-socialmedia__section');

    $tabBtn.on('click', function (e) {
      e.preventDefault();

      var $this = $(this),
          $thisItem = $this.parent(),
          $thisTarget = $($this.attr('href'));

      $tabItems.removeClass('is-tab-active');
      $thisItem.addClass('is-tab-active');

      $tabSection.removeClass('is-tab-active');
      $thisTarget.addClass('is-tab-active');

      // ARIA
      $tabBtn.attr('aria-selected', false);
      $this.attr('aria-selected', true);

      $tabSection.attr('aria-hidden', true);
      $thisTarget.attr('aria-hidden', false);

      // if ($thisItem.hasClass('is-tab-active')) {
      //   $thisItem.removeClass('is-tab-active');
      // } else {
      //
      // }
    });
  };

  module.init = function () {
    module.toggleTab();
  };

  return module;
}($.Sq.SocialTab || {});

$(document).ready(function () {
  var thisForm = $("#search_page_464398");

  $('.p-home__find-search').on('submit', "#search_page_464398", function (event) {
    event.preventDefault();

    var formData = new FormData($(this)[0]);
    var submitButton = $(this).find('input[type="submit"]'),
        submitButtonParam = submitButton.attr('name');

    formData.append(submitButtonParam, "Submit");

    var submitUrl = $(thisForm).attr("action") + "?queries_query_query=" + $("#search_page_464398 #queries_query_query").val();

    $.ajax({
      url: submitUrl,
      type: 'POST',
      data: formData,
      async: true,
      success: function success(data) {
        $(".p-home__find-search").html(data);
      },
      cache: false,
      contentType: false,
      processData: false
    });
  });
});

(function () {

  //hide/display google translate panel;
  $('.p-topnav__link').on('click', function (e) {
    if ($('#google_translate_element').offset() != undefined) {
      var $left = $('#google_translate_element').offset().left;
      $('iframe.goog-te-menu-frame').toggle();
      $('iframe.goog-te-menu-frame').css('top', '56px');
      $('iframe.goog-te-menu-frame').css('left', $left);
    } else {
      return;
    }
  });

  $(document.body).click(function (e) {
    var $box = $('iframe.goog-te-menu-frame');
    if (e.target.id !== 'google_translate_element') {
      $box.hide();
    }
  });

  //add class is-current on RHC fist list itme when page is news detail page;
  function addClass() {
    var pathname = window.location.pathname,
        assetId = $('.c-section-nav__title').attr('asset-id');

    var array = pathname.split('/'),
        lastsegment = array[array.length - 1];

    if (lastsegment.indexOf("news_article") > -1 || lastsegment.indexOf("news") > -1) {
      if (assetId === '460994') {
        $(".c-section-nav .c-section-nav__item").first().addClass("is-current");
      }
    }
  };

  //use AJAX function to display sub mega menu;
  function listMegaMenu() {
    $.ajax({
      url: "//www.police.nsw.gov.au/_integration/mega_menu/nested_mega_menu_-_wrapper",
      success: function success(html) {
        $(".submenu-container").append(html);
      }
    });
  };

  //replace font style on window system
  function replaceFont() {
    if (navigator.userAgent.toLowerCase().indexOf("windows") !== -1) {
      $('body').addClass('is-windows');
      if (navigator.userAgent.toLowerCase().indexOf("chrome") !== -1) {
        $('body').addClass('is-chrome');
      }
    }
    if (navigator.userAgent.toLowerCase().indexOf("firefox") !== -1) {
      $('body').addClass('is-firefox');
    }
  }

  replaceFont();
  listMegaMenu();
  addClass();
})();

/*
--------------------
Modules
--------------------
*/

(function ($) {
  $('abbr.timeago').timeago();
})(jQuery);

/* moduel */
(function () {
  var win = window,
      html = document.querySelector('html');

  var applyObjectfit = function applyObjectfit() {
    // sellect all element with class c-objectfit;
    var objectFits = document.querySelectorAll('.c-objectfit');
    //check if html tag contains object-fit
    if (!html.classList.contains('object-fit')) {

      if (!objectFits) return;

      for (var i = 0; i < objectFits.length; i++) {
        var objectFit = objectFits[i],
            container = document.createElement('div'),
            // create new wrapper element which could be difined by developer
        fitWraper = document.createElement('div'),
            imgWidth = objectFit.width,
            imgHeight = objectFit.height,
            imgUrl = objectFit.getAttribute('src');

        if (imgUrl) {
          container.style.backgroundImage = 'url(' + imgUrl + ')';
          container.classList.add('compat-object-fit');
          fitWraper.classList.add('compat-object-fit-wrapper');
          objectFit.parentNode.appendChild(container).appendChild(objectFit);
          container.parentNode.appendChild(fitWraper).appendChild(container);
          fitWraper.style.width = imgWidth + 'px';
          fitWraper.style.height = imgHeight + 'px';
          fitWraper.style.display = 'inline-block';
          objectFit.style.display = 'block';
        };
      };
    } else {
      for (var _i = 0; _i < objectFits.length; _i++) {
        var _objectFit = objectFits[_i],
            aTag = _objectFit.parentNode;
        if (aTag.nodeName.toLowerCase() === 'a' && aTag.href !== "") {
          aTag.classList.add('c-objectfit__wrapper');
        };
      };
    }
  };

  var init = function init() {
    applyObjectfit();
  };

  init();
})();
// Accordion

$.Sq = $.Sq || {};

$.Sq.Accordion = function (module) {

  // Module variables

  var _instances = [];

  var CLASS_ACTIVE = 'is-active';
  var CLASS_CURRENT = 'is-current';
  var CLASS_OPEN_MULTIPLE = 'js-open-multiple';
  var CLASS_TABS = 'js-is-tabs';
  var CLASS_TABS_ENABLED = 'js-tabs-enabled';

  var DEFAULT_OPTIONS = {
    selector: '.c-accordion',
    itemSelector: '.c-accordion__item',
    panelSelector: '.c-accordion__panel',
    titleSelector: '.c-accordion__title',
    tabsBreakpoint: 900,
    tabsEnabled: false,
    openMultiple: false
  };

  var OPTIONS_MAP = [{ className: CLASS_TABS_ENABLED, optionName: 'tabsEnabled' }, { className: CLASS_OPEN_MULTIPLE, optionName: 'openMultiple' }];

  function SqAccordion(elId, el) {
    var customOptions = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};

    console.log('Created SqAccordion \'' + elId + '\'');

    // Variables

    var accordion = {};

    var _options = Object.assign({}, DEFAULT_OPTIONS, customOptions);
    var _el = el;
    var _$items = Array.from(el.querySelectorAll(_options.itemSelector));
    var _$titles = Array.from(el.querySelectorAll(_options.titleSelector));
    var _$panels = Array.from(el.querySelectorAll(_options.panelSelector));
    var _tabHeight = el.querySelector(_options.titleSelector).offsetHeight;
    var _isTabs = false;

    init();

    // Private methods

    function init() {
      _$items[0].classList.add(CLASS_CURRENT);

      _$titles.forEach(function (item) {
        item.addEventListener('click', handleClick);
      });

      initARIA();
    }

    function handleFocus(e) {
      toggleItem.call(e.currentTarget.parentNode);
    }

    function handleClick(e) {
      e.preventDefault();
      toggleItem.call(this.parentNode, e);
    }

    function toggleItem() {
      var _this = this;

      _$items.forEach(function (item) {
        item.classList.remove(CLASS_CURRENT);
        if (!_options.openMultiple && item !== _this) {
          item.classList.remove(CLASS_ACTIVE);
        }
      });

      this.classList.add(CLASS_CURRENT);
      this.classList.toggle(CLASS_ACTIVE);
      accordion.handleResize();
    }

    function tab() {
      var $panelCurrent = _el.querySelector('.' + CLASS_CURRENT + ' ' + _options.panelSelector);
      var $panelInner = $panelCurrent.querySelector(_options.panelSelector + '__inner');

      _el.classList.add(CLASS_TABS);
      _el.style.height = $panelInner.offsetHeight + _tabHeight + 'px';
      $panelCurrent.style['min-height'] = $panelCurrent.style['max-height'] = $panelInner.offsetHeight + 'px';

      updateARIA();
    }

    function unTab() {
      _el.classList.remove(CLASS_TABS);
      _el.style.height = 'auto';

      _$panels.forEach(function (panel) {
        panel.style['min-height'] = 0;
        panel.style['max-height'] = panel.querySelector(_options.panelSelector + '__inner').offsetHeight + 'px';
      });

      updateARIA();
    }

    function initARIA() {
      _el.setAttribute('role', 'tablist');
      _el.setAttribute('aria-multiselectable', !_isTabs && _options.openMultiple);

      _$titles.forEach(function (title, index) {
        var targetId = title.nextElementSibling.id;
        title.setAttribute('role', 'button');
        title.setAttribute('aria-expanded', false);
        title.setAttribute('aria-controls', targetId);
        title.setAttribute('tabindex', index + 1);
      });

      _$panels.forEach(function (panel) {
        var targetId = panel.previousElementSibling.id;
        panel.setAttribute('role', 'tabpanel');
        panel.setAttribute('aria-hidden', true);
        panel.setAttribute('aria-labelledby', targetId);
      });
    }

    function updateARIA() {
      _el.setAttribute('aria-multiselectable', !_isTabs && _options.openMultiple);

      _$items.forEach(function (item) {
        var isExpanded = item.classList.contains(CLASS_ACTIVE);
        var isCurrent = item.classList.contains(CLASS_CURRENT);
        var $title = item.querySelector(_options.titleSelector);
        var $panel = item.querySelector(_options.panelSelector);

        $title.setAttribute('aria-expanded', isExpanded);
        $title.setAttribute('aria-selected', isCurrent);
        $panel.setAttribute('aria-hidden', !isExpanded);
      });
    }

    // Public methods

    accordion.handleResize = function () {
      _isTabs = _options.tabsEnabled && window.innerWidth > DEFAULT_OPTIONS.tabsBreakpoint;
      !_options.tabsEnabled || !_isTabs ? unTab() : tab();
    };

    return accordion;
  }

  // Module private methods

  function handleResize(e) {
    Object.keys(_instances).forEach(function (item) {
      _instances[item].handleResize();
    });
  }

  // Module public methods

  module.create = function (elId, el, customOptions) {
    if (_instances[elId]) {
      console.log('Warning: SqAccordion instance \'' + elId + '\' already exists');
      return;
    }

    if (!el) {
      console.log('Warning: SqAccordion element \'' + el + '\' not found');
      return;
    }

    // get additional options from element classes
    OPTIONS_MAP.forEach(function (option) {
      customOptions[option.optionName] = el.classList.contains(option.className);
    });

    _instances[elId] = SqAccordion(elId, el, customOptions);
    handleResize();
  };

  module.init = function () {
    var customOptions = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

    var selector = customOptions.selector || DEFAULT_OPTIONS.selector;
    Array.from(document.querySelectorAll(selector)).forEach(function (item, index) {
      module.create('accordion_' + index, item, customOptions);
    });
  };

  // Implementation

  window.addEventListener('resize', debounce(handleResize, 100));

  return module;
}($.Sq.Accordion || {});

$.Sq = $.Sq || {};

$.Sq.AjaxForm = function (module) {

  // Static properties

  var _instances = {};

  var DEFAULT_OPTIONS = {
    submitSelector: 'input[type="submit"]'
  };

  var SqAjaxForm = function SqAjaxForm(elId, element) {
    var customOptions = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};


    var form = {};

    // Private variables

    var _id = elId;
    var _el = element;
    var _options = _.merge({}, DEFAULT_OPTIONS, customOptions);
    var _submitBtn = document.querySelector(_options.submitSelector);

    // Error checks

    if (!_el) {
      throw new Error('Error: cannot find form \'' + _id + '\'');
    }

    _el.onsubmit = submitHandler;

    // Private methods

    function submitHandler(e) {
      e.preventDefault();
      console.log('AjaxForm: submitting \'' + _id + '\'');

      var formData = new FormData(this);
      formData.append(_submitBtn.name, _submitBtn.value);

      axios.post(this.getAttribute('action'), formData).then(function (response) {
        responseHandler(response);
      }).catch(function (error) {
        errorHandler(error);
      });
    }

    function responseHandler(response) {
      console.log('AjaxForm: successfully submitted \'' + _id + '\'');
      console.log(response);
      _el.innerHTML = response.request.response;
    }

    function errorHandler(error) {
      console.log('AjaxForm: error submitting \'' + _id + '\': ' + error);
    }

    // Public methods

    form.getId = function () {
      return _id;
    };

    form.getElement = function () {
      return _el;
    };

    return form;
  };

  // Module private methods

  function createInstance(elId, el, customOptions) {
    if (_instances[elId]) {
      throw new Error('Error: Ajax form \'' + elId + '\' already exists');
    }
    _instances[elId] = SqAjaxForm(elId, el, customOptions);
  }

  // Module public methods

  module.init = function () {
    var selector = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 'form';
    var customOptions = arguments[1];

    var forms = document.querySelectorAll(selector);
    Array.from(forms).forEach(function (item, index) {
      createInstance('form_' + index, item, customOptions);
    });
  };

  module.getInstances = function () {
    // return instances as an array
    return Object.keys(_instances).map(function (key) {
      return _instances[key];
    });
  };

  return module;
}($.Sq.AjaxForm || {});

$.Sq.DecisionTree = function (module) {

  var _instances = {};
  var _treeData = {};

  var _updateEvent = '$.Sq.Contact.contactPanelExpanded';
  var _idPrefix = 'sq_decisiontree_';

  var _defaultOptions = {
    treeSelector: '.p-decision-tree',
    backBtnClass: 'p-decision-tree__btn--back',
    listDataURL: 'mysource_files/tree1.html',
    decisionInnerContentClass: '.p-decision-tree__content-block',
    animationSpeed: 1,
    initialContainerWidth: 380
  };

  var SqDecisionTree = function SqDecisionTree(elId, el, customOptions) {

    var _options = Object.assign({}, _defaultOptions, customOptions);

    var _$el = el;
    var _$containers = _$el.querySelectorAll(_options.treeSelector + '__list-container');
    var _$innerContainer = _$el.querySelector(_options.treeSelector + '__inner');
    var _$currentContainer = _$el.querySelector(_options.treeSelector + '__current');
    var _$nextContainer = _$el.querySelector(_options.treeSelector + '__next');
    var _$previousContainer = _$el.querySelector(_options.treeSelector + '__previous');

    var _url = _$el.dataset.url;

    var tree = {};
    var _direction = 1;
    var _containerWidth = _options.initialContainerWidth;

    init();

    // Private methods

    function init() {
      // console.log( `initializing SqDecisionTree '${elId}'` );

      _$el.addEventListener('click', handleClick);
      window.addEventListener(_updateEvent, updateWidth);
      window.addEventListener('resize', updateWidth);

      showCurrentList(_url);
    }

    function handleClick(e) {
      e.preventDefault();
      _direction = e.target.classList.contains(_options.backBtnClass) ? -1 : 1;
      if (e.target.href && !e.target.closest(_options.decisionInnerContentClass)) {
        showCurrentList(e.target.href);
      } else if (e.target.href) {
        if (e.target.target == "_blank") {
          window.open(e.target.href);
        } else {
          window.location = e.target.href;
        }
      }
    }

    function handleError(e) {
      console.log('Error: ' + e);
    }

    function showCurrentList() {
      var url = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : _options.listDataURL;

      fetchListData(url).then(function (response) {
        updateTree(url, response.data);
        renderTree();
      }).catch(function (error) {
        return handleError(error);
      });
    }

    function fetchListData(url) {
      return new Promise(function (resolve, reject) {
        if (_treeData[url]) {
          resolve(_treeData[url]);
        } else {
          axios.get(url).then(function (response) {
            return resolve(response);
          }).catch(function (error) {
            return reject(error);
          });
        }
      });
    }

    function updateTree(url, data) {
      var treeNode = {
        url: url,
        data: data,
        previous: _direction === 1 ? _treeData.current : _treeData.current.previous,
        next: _direction === 1 ? undefined : _treeData.current
      };

      if (treeNode.previous && treeNode.previous.url === treeNode.url) {
        treeNode.previous = undefined;
      }

      if (_treeData.current) {
        _treeData.current.next = treeNode;
      }

      _treeData.current = _treeData[url] = treeNode;
    }

    function renderTree() {
      updateWidth();

      var currentNode = _treeData.current;
      var xOffset = _direction === 1 ? 0 : -(_containerWidth * 2);

      _$currentContainer.innerHTML = currentNode.data;
      _$previousContainer.innerHTML = currentNode.previous ? currentNode.previous.data : '';
      _$nextContainer.innerHTML = currentNode.next ? currentNode.next.data : '';

      TweenLite.from(_$innerContainer, _options.animationSpeed, {
        ease: Elastic.easeOut.config(.75, 1),
        css: { marginLeft: xOffset }
      });
    }

    function updateWidth() {
      if (!_$el.offsetWidth) {
        return;
      }

      _containerWidth = _$el.offsetWidth;
      _$innerContainer.style.marginLeft = -_containerWidth + 'px';

      Array.from(_$containers).forEach(function (item) {
        return item.style.width = _containerWidth + 'px';
      });
    }

    // Public methods

    return tree;
  };

  // Private methods

  function createInstance(elId, el, customOptions) {
    if (_instances[elId]) {
      throw new Error('Warning: DecisionTree instance ' + elId + ' already exists!');
      return;
    }

    if (!el) {
      throw new Error('Warning: DecisionTree element ' + el + ' not found!');
      return;
    }

    _instances[elId] = SqDecisionTree(elId, el, customOptions);
  }

  // Public methods

  module.init = function () {
    var customOptions = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

    var selector = customOptions.treeSelector || _defaultOptions.treeSelector;
    var $items = document.querySelectorAll(selector);

    Array.from($items).forEach(function (item, index) {
      createInstance('' + _idPrefix + index, item, customOptions);
    });
  };

  return module;
}($.Sq.DecisionTree || {});

// equivalent to jqeury document ready
var domReady = function domReady(callback) {
  document.readyState === 'interactive' || document.readyState === 'complete' ? callback() : document.addEventListener('DOMContentLoaded', callback);
};

domReady(function () {
  // Parallax
  //var parallax = $('.parallax').SquizParallax();

  /*
   * Hero Image Load
   * Uses imageLoad plugin installed from bower.
   *
   * @author Ryan <ryu@squiz.net>
   * @date   March 2017
   */
  //const $heroSection = document.querySelectorAll( '.p-hero--animation' );
  var $heroAnimation = Array.from(document.querySelectorAll('.p-hero--animation'));
  //const $heroImag = Array.from( document.querySelectorAll( '.p-hero--animation') );

  $heroAnimation.map(function (e, i) {
    //console.log(value, index);
    var $heroImg = e.querySelector('.p-hero__img-wrapper');
    var heroImgLoad = imagesLoaded($heroImg);

    heroImgLoad.on('progress', function (instance, image) {
      e.classList.add('is-hero-image-loaded');
    });
  });
});

(function () {
  var addImgCaption = function addImgCaption() {
    //collect all image elements with class c-img-caption
    var cImgCaptions = document.querySelectorAll('img[title]');

    if (!cImgCaptions) return;

    var _loop = function _loop(i) {

      var cImgCaption = cImgCaptions[i],
          imgFigure = document.createElement('figure'),
          imgFigcaption = document.createElement('figcaption'),
          imgCaption = cImgCaption.getAttribute('title'),
          imgStyle = cImgCaption.getAttribute('style'),
          imgClasses = cImgCaption.getAttribute('class');
      //imgWidth      = cImgCaption.width;

      imagesLoaded(cImgCaption, function () {
        var imgWidth = cImgCaption.width;

        if (imgCaption) {
          imgFigure.setAttribute('style', imgStyle);
          imgFigure.setAttribute('class', imgClasses);
          imgFigure.style.width = imgWidth + 'px';
          cImgCaption.removeAttribute('style');
          cImgCaption.parentNode.appendChild(imgFigure);
          imgFigure.appendChild(cImgCaption);
          imgFigure.appendChild(imgFigcaption);
          imgFigcaption.innerText = imgCaption;

          // move figure before non-markedup paragraph
          $(imgFigure).prependTo(imgFigure.parentNode);
        };
      });
    };

    for (var i = 0; i < cImgCaptions.length; i++) {
      _loop(i);
    };
  };

  var init = function init() {
    addImgCaption();
  };

  init();
})();

(function () {
  $.fn.customLightbox = function (config) {
    var $html = $('html'),
        $body = $('body'),
        closeSelector = '.js-lightbox-close',
        containerSelector = '.js-lightbox-container',
        $current,
        mqDesktop = 'screen and (min-width: 64em)',
        defaultConfig = {};

    $.extend(defaultConfig, config);

    var beforeShowup = defaultConfig.beforeShowup,
        afterShowup = defaultConfig.afterShowup,
        beforeClose = defaultConfig.beforeClose,
        afterClose = defaultConfig.afterClose;

    this.each(function () {
      var targetId = $(this).attr('data-target'),
          $lightboxClose = $(closeSelector);

      $(this).bind('click', function (e) {
        e.preventDefault();
        var $target = $('#' + targetId);

        // HOOK: beforeShowup
        if (typeof beforeShowup === 'function') {
          beforeShowup.call(this);
        }

        if ($current !== undefined && $current.hasClass('is-active') && !$(this).hasClass('js-lightbox-close')) {
          $current.removeClass('is-active');
        }

        $current = $target;
        if (!window.matchMedia(mqDesktop).matches) {
          $target.removeClass('hidden');
          $target.siblings().addClass('hidden');
        } else {
          $body.addClass('u-overflow-hidden');
          !window.matchMedia(mqDesktop) && $html.addClass('u-overflow-hidden');
        }
        $target.toggleClass('is-active');

        // HOOK: afterShowup
        if (typeof afterShowup === 'function') {
          afterShowup.call(this);
        }
      });

      //$lightboxClose.each(function() {
      $lightboxClose.bind('click', function (e) {
        e.preventDefault();

        // HOOK: beforeClose
        if (typeof beforeClose === 'function') {
          beforeClose.call(this);
        }

        $(this).closest(containerSelector).removeClass('is-active');
        $(this).closest(containerSelector).siblings().removeClass('hidden');
        $body.removeClass('u-overflow-hidden');
        !window.matchMedia(mqDesktop) && $html.removeClass('u-overflow-hidden');

        // HOOK: afterClose
        if (typeof afterClose === 'function') {
          afterClose.call(this);
        }
      });
      //});
    });

    return this;
  };
})();

$(document).ready(function () {

  $('#feedback-survey-trigger').magnificPopup({
    type: 'inline'
  });

  /*
   * set cookie
   *
   * @param [string] cname            [cookie name]
   *        [string/number..] cvalue  [cookie value]
   *        [number] exdays           [cookie expire days]
   */
  var setCookie = function setCookie(cname, cvalue, exdays) {
    var d = new Date();
    d.setTime(d.getTime() + exdays * 24 * 60 * 60 * 1000);
    var expires = 'expires=' + d.toUTCString();

    document.cookie = cname + '=' + cvalue + ';' + expires + ';path=/';
  },


  /*
   * get cookie
   *
   * @param [string] cname              [cookie name]
   * @return [string/number ...] cvalue [cookie value]
   */
  getCookie = function getCookie(cname) {
    var name = cname + '=';
    var ca = document.cookie.split(';');
    for (var i = 0; i < ca.length; i++) {
      var c = ca[i];
      while (c.charAt(0) === ' ') {
        c = c.substring(1);
      }
      if (c.indexOf(name) === 0) {
        return c.substring(name.length, c.length);
      }
    }
    return '';
  },


  /*
   * has cookie
   *
   * @param [string] cname              [cookie name]
   * @return [bool] true/false
   */
  hasCookie = function hasCookie(cname) {
    var cvalue = getCookie(cname),
        result = false;

    if (cvalue !== '') {
      result = true;
    }
    return result;
  };

  // #.Ajax form
  var urlDomId = 'contact-form-url',
      $ajaxFormContainer = $('.js-ajax-form-container'),
      hasAjaxLoaderClass = 'u-has-ajax-loader',
      ajaxLoaderClass = '.u-ajax-loader',
      bindAjaxToSubmit = function bindAjaxToSubmit(url, $container) {
    if ($container.find('form *[type=submit]').length > 0) {
      $container.find('form *[type=submit]').on('click', {
        container: $container
      }, function (e) {
        e.preventDefault();
        var data = $(this).closest('form').serialize() + '&' + $(this).attr('name') + '=' + $(this).val();
        submitContactForm(url, data, $container);
      });
    }
  },
      bindToCloseButton = function bindToCloseButton() {
    if ($('.c-lightbox__close-button.js-lightbox-close').length > 0) {
      $('.c-lightbox__close-button.js-lightbox-close').bind('click', function (event) {
        event.preventDefault();
        var containerSelector = '.js-lightbox-container';
        var $html = $('html'),
            $body = $('body'),
            mqDesktop = 'screen and (min-width: 64em)';
        $(this).closest(containerSelector).removeClass('is-active');
        $(this).closest(containerSelector).siblings().removeClass('hidden');
        $body.removeClass('u-overflow-hidden');
        !window.matchMedia(mqDesktop) && $html.removeClass('u-overflow-hidden');
      });
    }
  },
      submitContactForm = function submitContactForm(url, data, $container) {
    $.ajax({
      type: 'POST',
      url: url,
      data: data,
      container: $container

    }).done(function (data, msg) {
      if (msg === 'success') {
        var $container = this.container;
        $container.empty().append(data);
        //packageSelectBox();
        bindAjaxToSubmit(url, $container);
        bindToCloseButton();
        //formValidate();
      }
    });
  },
      ajaxFormFunc = function ajaxFormFunc($formContainer, url) {
    $.ajax({
      type: 'GET',
      url: url,
      container: $formContainer

    }).done(function (data, msg) {
      if (msg === 'success') {
        var $container = this.container;

        $container.removeClass(hasAjaxLoaderClass);
        $container.find(ajaxLoaderClass).remove();
        $container.append(data);
        // add wrap to normal Select box
        //packageSelectBox(); // predefined above
        bindAjaxToSubmit(url, $container);
        //formValidate();
      }
    });
  };

  // #. Online survey
  var fsCookieName = 'feedback_survey_timer',
      fsBlockerCookieName = 'feedback_survey_blocker',
      fsExDays = 1,
      interval = 5000,
      fsData = JSON.parse($('#feedback-survey-data').html() || '{}'),

  //_fsFireTime = parseFloat(fsData.fire_time, 10),
  _fsFireTime = fsData.fire_time,
      fsFireTime = isNaN(_fsFireTime) ? 2000 : _fsFireTime; // in minute

  // set timer/blocker for feedback survey
  (function () {
    if (hasCookie(fsBlockerCookieName)) {
      // console.log('has blocker');
      // setCookie(fsBlockerCookieName, '');
      return;
    }
    if (!hasCookie(fsCookieName)) {
      setCookie(fsCookieName, "0", fsExDays);
    }

    if (!$('.feedback_survey').length) {
      return;
    }

    if ($('.feedback_survey').length) {
      var surveyInterval = setTimeout(function () {
        var _timerValue = parseFloat(getCookie(fsCookieName), 10),
            timerValue = isNaN(_timerValue) ? 0 : _timerValue;

        console.log(timerValue, fsFireTime);
        if (timerValue > fsFireTime - 1 && !hasCookie(fsBlockerCookieName)) {
          $('#feedback-survey-trigger').trigger('click');

          // set cookie to block survey lightbox shows up
          setCookie(fsBlockerCookieName, 'true', fsExDays);
          return;
        }

        if (!hasCookie(fsBlockerCookieName)) {
          setCookie(fsCookieName, fsFireTime, fsExDays);
        }
      }, interval);
    }
  })();

  var ajaxFeedbackSurvey = function ajaxFeedbackSurvey() {
    var fsUrl = $('.feedback_survey').attr('data-survey-url');
    console.log(fsUrl);
    var $container = $('#lightbox-feedback-survey .lightbox__content');
    ajaxFormFunc($container, fsUrl);
  },
      afterClose = function afterClose() {
    // erase the form
    $('#lightbox-online-survey .c-lightbox__desc').empty();
  };

  //setCookie(fsBlockerCookieName, 'true', fsExDays);
  $('#feedback-survey-trigger').customLightbox({
    afterShowup: ajaxFeedbackSurvey,
    afterClose: afterClose
  });
});
(function () {

  // add class to element
  // http://youmightnotneedjquery.com/#add_class
  var addClass = function addClass(element, className) {
    if (element.classList) {
      element.classList.add(className);
    } else {
      element.className += '' + className;
    }
  };

  // remove class from element
  // http://youmightnotneedjquery.com/#remove_class
  var removeClass = function removeClass(element, className) {
    var regex = new RegExp('(^|\\b)' + className.split(' ').join('|') + '(\\b|$)', 'gi');
    if (element.classList) {
      element.classList.remove(className);
    } else {
      element.className = element.className.replace(regex, ' ');
    }
  };

  // Detect if table is scrolled to the right end
  // Add/Remove class 'is-end' to indicate
  var isTblScrolledToRight = function isTblScrolledToRight() {
    var containers = document.querySelectorAll('.e-tbl__inner');

    var _loop2 = function _loop2(i) {
      var container = containers[i],
          containerParent = container.parentElement,
          containerWidth = container.offsetWidth,
          tbl = container.getElementsByTagName('table')[0];

      container.onscroll = function () {
        var tblRect = tbl.getBoundingClientRect();

        if (tblRect.right <= containerWidth) {
          addClass(containerParent, 'is-end');
        } else {
          removeClass(containerParent, 'is-end');
        }
      };
    };

    for (var i = 0; i < containers.length; i += 1) {
      _loop2(i);
    }
  };

  // Check if table is wrapped
  var isTblWrapped = function isTblWrapped(tbl) {
    if (tbl.parent.classList.contains('e-tbl__inner')) {
      return true;
    }

    return false;
  };

  // clone classes from source element to destination element
  var cloneClassList = function cloneClassList(srcEle, destEle) {
    for (var i = 0; i < srcEle.classList.length; i += 1) {
      destEle.classList.add(srcEle.classList[i]);
    }
  };

  // Unwrap table
  var unwrapTbl = function unwrapTbl(tbl) {
    // Quit, if table is not wrapped
    if (!isTblWrapped(tbl)) {
      return;
    }

    // find table outer wrapper
    var tblOuterWrapper = tbl.parent.parentElement;

    // Quit, if the table is not correctly wrapped
    if (!tblOuterWrapper.classList.contains('e-tbl__wrapper') || !tbl.parent.classList.contains('e-tbl__inner')) {
      return;
    }

    // Find table caption, create new element
    var tblCaption = tblOuterWrapper.querySelectorAll('.e-tbl__caption')[0],
        newTbl = document.createElement('table');

    // Clone classes from original table to new one
    cloneClassList(tbl.table, newTbl);

    // If table has caption, insert caption into newly created table node
    if (tblCaption) {
      tblCaption = '<caption>' + tblCaption.innerHTML + '</caption>';
      newTbl.insertAdjacentHTML('afterbegin', tblCaption);
    }

    // Insert table content into newly created table node
    newTbl.insertAdjacentHTML('beforeend', tbl.table.innerHTML);
    // Append new node in front of wrapped table, and remove wrapped one
    tblOuterWrapper.parentElement.insertBefore(newTbl, tblOuterWrapper);
    tblOuterWrapper.parentElement.removeChild(tblOuterWrapper);
  };

  // Wrap table
  var wrapTbl = function wrapTbl(tbl) {
    // Create outer wrapper element and new html content
    var tblCaption = tbl.table.getElementsByTagName('caption')[0],
        tblOuterWrapper = document.createElement('div'),
        newInnerHTML = '<div class="e-tbl__inner">' + tbl.table.outerHTML + '</div>';

    // If table has a caption
    // Put table caption outside inner wrapper so that it would stay in viewport
    if (tblCaption) {
      // remove original caption
      tbl.table.removeChild(tblCaption);
      // put caption content in '.e-tbl__caption' container
      newInnerHTML = '<div class="e-tbl__caption">' + tblCaption.innerHTML + '</div>\n        <div class="e-tbl__inner">' + tbl.table.outerHTML + '</div>';
    }

    // Insert wrapped table before original table, and remove original one
    tblOuterWrapper.className = 'e-tbl__wrapper';
    tbl.parent.insertBefore(tblOuterWrapper, tbl.table);
    tblOuterWrapper.innerHTML = newInnerHTML;
    tbl.parent.removeChild(tbl.table);
  };

  var isTblOverflow = function isTblOverflow(tbl) {
    if (tbl.table.offsetWidth > tbl.parent.offsetWidth) {
      return true;
    }

    return false;
  };

  // Check if table is valid
  // * table doesn't have classes to disable scroll
  // * table is not wrapped
  var isValidTbl = function isValidTbl(tbl) {
    if (tbl.table.classList.contains('no-tbl-scrollable')) {
      return false;
    }

    return true;
  };

  // Make tables responsive
  var handleResponsiveTbls = function handleResponsiveTbls(event) {
    // Find all tables
    var tbls = document.querySelectorAll('table');

    // Stop if there were no tables inside html document
    if (!tbls) {
      return;
    }

    // Check tables
    for (var i = 0; i < tbls.length; i += 1) {
      // let tbl = tbls[i],
      //   tblParent = tbl.parentElement;
      var _tbl = {
        'table': tbls[i],
        'parent': tbls[i].parentElement
      };

      // Skip invalid tables
      if (!isValidTbl(_tbl)) {
        continue;
      }

      // Table overflows and not wrapped, needs to be wrapped
      if (isTblOverflow(_tbl) && !isTblWrapped(_tbl)) {
        wrapTbl(_tbl);
      }

      // Table not overflow and wrapped, needs to be unwrapped
      if (!isTblOverflow(_tbl) && isTblWrapped(_tbl)) {
        unwrapTbl(_tbl);
      }
    }

    // Show/Hide right end gradient mask by adding/removing class
    isTblScrolledToRight();
  };

  // Start
  var init = function init() {
    // Make tables responsive
    window.onload = function () {
      handleResponsiveTbls('load');
    };

    window.onresize = function () {
      handleResponsiveTbls('resize');
    };
  };

  // Start
  init();
})();
// //*-- Accordion --*//
// var $sectionNavItem = $('.c-section-nav__item');
//
// $sectionNavItem.each(function() {
//   var $this = $(this),
//       $thisContent = $this.children('.c-section-nav__content');
//
//   // init on page load
//   if ($this.hasClass('is-section-nav-active')) {
//     // do nothing
//   } else {
//     // hide content
//     $thisContent.hide();
//   }
// });
//
// var $sectionNavBtn = $('.c-section-nav__btn');
// $sectionNavBtn.on('click', function(e) {
//   if (Modernizr.mq('only screen and (max-width: 959px)')) {
//     e.stopPropagation();
//     e.preventDefault();
//
//     var $this = $(this),
//         $thisContent = $this.parent().next('.c-section-nav__content'),
//         $thisItem = $this.closest('.c-section-nav__item'),
//         $navItem = $('.c-section-nav__item');
//
//   // if ($thisItem.hasClass('is-section-nav-active')) {
//   //   $thisContent.velocity('slideUp');
//   //   $thisItem.removeClass('is-section-nav-active');
//   // } else {
//   //   $thisContent.velocity('slideDown');
//   //   $thisItem.addClass('is-section-nav-active');
//   // }
//
//
//     if ($thisItem.hasClass('is-current')) {
//       $navItem.velocity('slideDown');
//     } else {
//       window.location.href = $this.attr('href');
//     }
//   }
// });
//
// $(window).on('click touchstart', function() {
//   if (Modernizr.mq('only screen and (max-width: 959px)')) {
//     let $navItem = $('.c-section-nav__item:not(.is-current)');
//
//     $navItem.velocity('slideUp');
//   }
// });
// if (Modernizr.mq('only screen and (max-width: 959px)')) {
/*let $sectionNavBtn = $('.c-section-nav__btn');
 $sectionNavBtn.on('touchstart', function(e) {
  e.stopPropagation();
   let $this = $(this),
      $thisNav = $this.closest('.c-section-nav');
   if ($thisNav.hasClass('is-expanded')) {
    // collapse
    window.location.href = $this.attr('href');
    $thisNav.removeClass('is-expanded');
  } else {
    // expand
    e.preventDefault();
     $('.c-section-nav__item').velocity('slideDown');
    $('.c-section-nav__title').velocity('slideDown');
    $thisNav.addClass('is-expanded');
  }
});
 $(window).on('touchstart', function() {
   let $navItem = $('.c-section-nav__item:not(.is-current)');
   $navItem.velocity('slideUp');
  $('.c-section-nav__title').velocity('slideUp');
   $('.c-section-nav').removeClass('is-expanded');
});
 // close section nav
let $closeSectionNav = $('.js-close-section-nav');
 $closeSectionNav.on('touchstart', function(e) {
  e.stopPropagation();
  e.preventDefault();
   let $this = $(this),
      $thisNav = $this.closest('.c-section-nav');
   $('.c-section-nav__item:not(.is-current)').velocity('slideUp');
  $('.c-section-nav__title').velocity('slideUp');
  $thisNav.removeClass('is-expanded');
})*/

//   $('h2.c-section-nav__title, .js-close-section-nav').on('touchstart', function (e) {
//     e.stopPropagation();
//     e.preventDefault();
//     let $this = $(this),
//         $thisNav = $this.closest('.c-section-nav');

//     $thisNav.toggleClass('is-expanded');
//     $('.c-section-nav__item ').toggle('600');
//   });
// }

// $(window).resize(function(){
//   if (Modernizr.mq('only screen and (max-width: 959px)')) {
//     if($('.c-section-nav').hasClass('is-expanded')) {
//       $('.c-section-nav__item ').show();
//     } else {
//       $('.c-section-nav__item ').hide();
//     }
//   }
//   if (Modernizr.mq('only screen and (min-width: 960px)')) {
//     $('.c-section-nav__item ').show();
//   }
// });

var disableExpandSectionNav = function disableExpandSectionNav() {
  $('h2.c-section-nav__title, .js-close-section-nav').off('touchstart mousedown');
};

var enableExpandSectionNav = function enableExpandSectionNav() {
  disableExpandSectionNav();

  $('h2.c-section-nav__title, .js-close-section-nav').on('touchstart mousedown', function (e) {
    e.stopPropagation();
    e.preventDefault();

    $('.c-section-nav').toggleClass('is-expanded');
    $('.c-section-nav__item ').toggle('600');
  });
};

$(window).on('load resize', function (event) {
  if (event.type == 'load') {
    $('.js-close-section-nav').on('click', function (e) {
      e.preventDefault();
    });
  }

  if (Modernizr.mq('only screen and (max-width: 959px)')) {
    if ($('.c-section-nav').hasClass('is-expanded')) {
      $('.c-section-nav__item ').show();
    } else {
      $('.c-section-nav__item ').hide();
    }

    enableExpandSectionNav();
  }

  if (Modernizr.mq('only screen and (min-width: 960px)')) {
    $('.c-section-nav').removeClass('is-expanded');
    $('.c-section-nav__item ').show();

    disableExpandSectionNav();
  }
});

(function () {
  var $window = $(window),
      $sliders = $('.js-carousel'),
      defaultSettings = {
    arrows: true,
    autoplay: true,
    autoplaySpeed: 2000,
    centerMode: false,
    cssEase: 'cubic-bezier(.77, 0, .175, 1)',
    dots: true,
    infinite: true,
    prevArrow: '<button type="button" class="slick-prev slick-arrow">\n      <span class="slick-arrow__txt">Previous</span></button>',
    nextArrow: '<button type="button" class="slick-next slick-arrow">\n      <span class="slick-arrow__txt">Next</span></button>',
    slidesToShow: 3,
    slidesToScroll: 3,
    speed: 400,
    responsive: [{
      breakpoint: 900,
      settings: {
        centerMode: false,
        slidesToShow: 2,
        slidesToScroll: 2
      }
    }]
  },
      mqSmall = '(max-width: 599px)',
      mqMedium = '(min-width: 600px)',
      mqWide = '(min-width: 960px)',
      mqExtraWide = '(min-width: 1200px)';

  var isInteger = function isInteger(val) {
    if ($.isNumeric(val) && Math.floor(val) === val) {
      return true;
    }

    return false;
  };

  var getSliderSettings = function getSliderSettings($ele) {
    var settings = $.extend({}, defaultSettings),
        options = {
      arrows: $ele.data('arrows'),
      autoplay: $ele.data('autoplay'),
      autoplaySpeed: $ele.data('autoplayspeed'),
      centerMode: $ele.data('centermode'),
      dots: $ele.data('dots'),
      slidesToShow: $ele.data('slidestoshow'),
      speed: $ele.data('speed')
    };

    if (options.arrows === 'off') {
      settings.arrows = false;
    }

    if (options.autoplay === 'off') {
      settings.autoplay = false;
    }

    if (options.autoplaySpeed) {
      if (isInteger(options.autoplaySpeed)) {
        settings.autoplaySpeed = options.autoplaySpeed;
      }
    }

    if (options.centerMode === 'on') {
      settings.centerMode = true;
    }

    if (options.dots === 'off') {
      settings.dots = false;
    }

    if (options.slidesToShow) {
      if (isInteger(options.slidesToShow)) {
        settings.slidesToShow = options.slidesToShow;
      }
    }

    if (options.speed) {
      if (isInteger(options.speed)) {
        settings.speed = options.speed;
      }
    }

    return settings;
  };

  var createSlick = function createSlick($ele, settings) {
    if (!$ele.hasClass('slick-initialized')) {
      $ele.slick(settings);
    }
  };

  var destroySlick = function destroySlick($ele) {
    if ($ele.hasClass('slick-initialized')) {
      $ele.slick('unslick');
    }
  };

  var deactiveSliders = function deactiveSliders() {
    if (!$sliders) {
      return;
    }

    $sliders.map(function (i) {
      var $slider = $($sliders[i]);
      destroySlick($slider);
    });
  };

  var activeSliders = function activeSliders() {
    if (!$sliders) {
      return;
    }

    $sliders.map(function (i) {
      var $slider = $($sliders[i]),
          settings = getSliderSettings($slider);

      createSlick($slider, settings);
    });
  };

  var initSliders = function initSliders() {
    $window.on('load resize', function () {
      if (Modernizr.mq(mqSmall)) {
        deactiveSliders();
      } else {
        activeSliders();
      }
    });
  };

  var init = function init() {
    initSliders();
  };

  init();
})(jQuery);

// (function() {
//
//   /**
//   MEDIA DISPLAY JS FUNCTION
//   */
//   const ERRORS = {
//     '34': 'Connection error. Please review site social media configuration.',
//     generic: 'Unknown error.'
//   };
//
//   const mediaDetail = {
//     render: function(data, template) {
//       var listing = template,
//           form = '',
//           noResults = '',
//           template  = null;
//       //Twitter error handling
//       try {
//         if(data.items.errors.length > 0) {
//             this.processErrors(data.items.errors);
//             return;
//         }
//       } catch (error) {}
//
//       //Facebook error handling
//       try {
//         if(data.items.hasOwnProperty('error')) {
//           print(this.getErrorElement(ERRORS['34']));
//         }
//       } catch(error) {}
//
//       //compile data to template
//       try {
//         let items = data;
//         template = Handlebars.compile(listing.html());
//
//
//         console.log(items);
//         console.log(template(items));
//
//         $('.o-container').append(template(items));
//         console.log('work');
//       } catch (error) {
//         console.log(this.getErrorElement(error));
//         console.log("Error:");
//         template = Handlebars.compile(noResults);
//         console.log(template(data));
//         console.log('not work');
//       }
//     },
//
//     getErrorElement: function(errorMsg) {
//       return ['<span>', errorMsg, '</span>'].join('');
//     }
//   };
//
//
//   /**
//   CUSTOM HANDLERBAR HELPER JS FUNCTION
//   */
//   Handlebars.registerHelper('checkAuthor', function(data) {
//     if(data.retweeted_status == null) {
//       return data.user.name;
//     }else {
//       if(data.entities.user_mentions.length > 0){
//         return data.entities.user_mentions[0].name;
//       } else {
//         return data.user.name;
//       }
//     }
//   });
//
//   Handlebars.registerHelper('checkImage', function(data) {
//     if(data.retweeted_status != null){
//       return data.retweeted_status.user.profile_image_url.replace('http','https');
//     } else {
//       return data.user.profile_image_url.replace('http','https');
//     }
//   });
//
//   Handlebars.registerHelper('checkAccount', function(data) {
//     if(data.retweeted_status != null){
//       return data.retweeted_status.user.screen_name;
//     } else {
//       return data.user.screen_name;
//     }
//     // return user.screen_name;
//   });
//
//   Handlebars.registerHelper('createdDate', function(data) {
//     let monthNames = [
//         "January", "February", "March",
//         "April", "May", "June", "July",
//         "August", "September", "October",
//         "November", "December"
//     ];
//
//     if(date) {
//       date = (type === 'insta') ? date * 1000 : date;
//       let c = new Date(date),
//           n = new Date();
//           diff = Math.round((n - c) / (24*60*60*1000));
//       if(diff < 1) {
//         let time_diff = Math.round((n - c) / (24*60*1000));
//         if(time_diff < 1) {
//           let hour_diff = Math.round((n - c) / (24*1000));
//           return hour_diff+"m ago";
//         } else { return time_diff+"h ago";}
//       } else if(diff == 1) {
//         return diff+" day ago";
//       } else if(diff <= 5) {
//         return diff+" days ago";
//       } else {
//         return monthNames[c.getMonth()] + ' ' +c.getDate();
//       }
//
//     } else { return null}
//   });
//
//   Handlebars.registerHelper('arrayCheck', function (index, options) {
//     if(index < 4) return options.fn(this);
//   });
//
//   Handlebars.registerHelper('getVideoID', function (url) {
//     var id = url.substring(url.lastIndexOf('/') + 1);
//     return id;
//   });
//
//   /**
//   HANDLING SOCITAL MEDIA
//   **/
//
//   const handleTwitterData = () => {
//     axios.get("js/json/twitter.json")
//     .then(function(response) {
//       var json = response.data;
//       var media = { items: json };
//       console.log(json);
//       //mediaDetail.render(media, $('#twitter-template'));
//       mediaDetail.render(json, $('#twitter-template'));
//
//     })
//     .catch(function(error) {
//       console.log(error);
//     });
//   };
//
//
//   var init = () => {
//     handleTwitterData();
//   };
//
//   init();
//
// })();
//# sourceMappingURL=global.js.map
